package easik.ui.menu.popup;

import java.awt.event.ActionEvent;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import easik.Easik;
import easik.sketch.Sketch;
import easik.sketch.edge.SketchEdge;
import easik.sketch.vertex.EntityNode;


/** 
 * This class contains the action for the click on the popup menu to create an 
 * new edge. This could be boiled down a little bit in order to remove extra
 * classes (possibly combining it with the other edge adding routine)
 * 
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @version 2006-07-13 Kevin Green
 */
public class NewEdgeAction extends AbstractAction {
	/**
	 * Prepare the menu option for a new edge
	 *
	 */
	public NewEdgeAction() {
		super("Add edge...");		
		putValue(
			AbstractAction.SHORT_DESCRIPTION,
			"Connect the two selected nodes with an edge");
	}

	/**
	 * The action for creating a new edge. Make sure the selection is alright, and 
	 * then create the edge.
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e) {
		Sketch _ourSketch = Easik.getInstance().getFrame().getSketch();
		int nodeCount = 0;
		EntityNode node[] = new EntityNode[2];

		Vector currentSelection =
			_ourSketch.getSelectionListener().getCurrentSelection();

		if (currentSelection.size() == 2) {
			for (int i = 0; i < 2; i++) {
				node[i] = null;
				if (currentSelection.get(i) instanceof EntityNode) {
					node[i] = (EntityNode) currentSelection.get(i);
				}
			}
		}

		if ((node[0] == null) || (node[1] == null)) {
			JOptionPane.showMessageDialog(
				_ourSketch.getParent(),
				"Operation must be performed with two entities selected",
				"Error",
				JOptionPane.ERROR_MESSAGE);
		} else {
			String options[] = new String[2];
			options[0] = node[0] + " to " + node[1];
			options[1] = node[1] + " to " + node[0];

			String s =
				(String) JOptionPane.showInputDialog(
					_ourSketch.getParent(),
					"Select edge's direction:",
					"Add Edge",
					JOptionPane.QUESTION_MESSAGE,
					null,
					options,
					options[0]);

			if (s != null) {				
				SketchEdge newEdge = null;
				if (s.equals(options[0])) {					
					newEdge =
						new SketchEdge(
							(EntityNode)node[0],
							(EntityNode)node[1],
							_ourSketch.getNewEdgeName(false),
							false);
				} else if (s.equals(options[1])) {					
					newEdge =
						new SketchEdge(
							(EntityNode)node[1],
							(EntityNode)node[0],
							_ourSketch.getNewEdgeName(false),
							false);
				}				
				_ourSketch.addEdge(newEdge);
				_ourSketch.setDirty(true);				
			}
		}
	}
}
